<!DOCTYPE html>
<html lang="pt">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cardapio On Line - <?= !empty($title) ? $title : '' ?></title>


    <!-- fonte -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
  
    <!-- favicon -->
    <link rel="shortcut icon" href="<?= base_url('assets/images/logo.png') ?>" type="image/png">

    <!-- bootstrap -->
    <link rel="stylesheet" href="<?= base_url('assets/libs/bootstrap/bootstrap.min.css') ?>">

    <!-- fontawesome -->
    <link rel="stylesheet" href="<?= base_url('assets/libs/fontawesome/all.min.css') ?>">

    <!-- css -->
    <link rel="stylesheet" href="<?= base_url('assets/css/main_home.css') ?>">
    
</head>

<body>

    <!-- top bar -->
    <?= $this->include('partials/top_bar_home.php') ?>
    
    <!-- main -->
    <section class="d-flex">
        
        <!-- content -->
        <div class="content p-4 flex-fill">
            <?= $this->renderSection('content') ?>
        </div>

    </section>

    <!-- footer -->
    <?= $this->include('partials/footer.php') ?>

    <!-- boostrap -->
    <script src="<?= base_url('assets/libs/bootstrap/bootstrap.bundle.min.js') ?>"></script>

    <script>
        document.querySelector(".btn-main-menu").addEventListener("click", () => {
            document.querySelector(".main-menu").classList.toggle("show");
            document.querySelector(".content").classList.toggle("show");
        })
    </script>
</body>

</html>