<?= $this->extend('layouts/layout_home') ?>
<?= $this->section('content') ?>
<div class="container">

    <section class="hero">
    <img src="assets/images/Cardapio002.jpeg" alt="Celular com cardápio">
    <div class="hero-text">
      <h2>Seu cardápio digital em minutos</h2>
      <p>Ideal para foodtrucks, bares, lanchonetes e pequenos negócios. Crie seu menu, gere o QR Code e compartilhe com seus clientes.</p>
      <a href="#" class="btn">Crie agora seu cardápio</a>
    </div>
  </section>

  <section class="features">
    
    <div class="feature">
      <h3>✅ Fácil de usar</h3>
      <p>Cadastre produtos por categorias, fotos e preços em poucos cliques.Controle a qualquer momento o cadastro das categorias do seu comercio, como bebidas, lanches, sobremesas, etc</p>
    </div>
    
    <div class="feature">
      <h3>📱 QR Code instantâneo</h3>
      <p>Gere e compartilhe seu cardápio digital por QR Code, sem precisar de aplicativo.</p>
    </div>
    
    <div class="feature">
      <h3>🕒 Atualize a qualquer momento</h3>
      <p>Altere preços, dados ou fotos dos produtos a qualquer hora e de onde estiver, É facil e sem complicações.</p>
    </div>

  </section>

  <section class="registers" >
      <div class="row gy-4">
            <div class="col-lg-7 position-relative align-self-start" data-aos="fade-up" data-aos-delay="100">
                <div class="signup-text">
                    <h4 style="color: #ff6600;">Cadastre-se no Cardápio On Line e começe a criar seu menu de forma digital.</h4>
                        <ul>
                        <li><i class="bi bi-check2-all"></i> <span>Teste gratuitamente por <b>15 dias</b>;</span></li>
                        <li><i class="bi bi-check2-all"></i> <span>Mais barato que um lanche.;</span></li>
                        <li><i class="bi bi-check2-all"></i> <span>Seu cardápio on line no menor custo;</span></li>
                        <li><i class="bi bi-check2-all"></i> <span>Ate 03 tipo de laiaute de cardápio.</span></li>
                    </ul>
                    <div class="row">
                        <div class="mb-3">
                            <a href="<?= site_url('/auth/login') ?>" class="btn btn-sm btn-success w-40">
                                Faça o login
                            </a>
                        </div>
                    </div>
                </div>
            </div>   

            <div class="col-lg-5 content" data-aos="fade-up" data-aos-delay="100">
                <div class="signup-form">
                   <h4>Crie sua conta gratuitamente</h4>
                   <?= form_open_multipart(base_url('home/registrarUsuario')) ?>
                   <?php if (session()->getFlashdata('errors')): ?>
                        <div class="alert alert-danger">
                            <ul>
                                <?php foreach (session()->getFlashdata('errors') as $erro): ?>
                                    <li><?= esc($erro) ?></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                
                    <?php if (session()->getFlashdata('sucesso')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert" id="alert-success">
                            <?= session()->getFlashdata('sucesso') ?>
                        </div>
                    <?php endif; ?>  
                    <div class="col-lg-12 col-12 p-1">

                    <!-- MENSAGEM DE ERRO GLOBAL -->
                    <?php if (session()->getFlashdata('erro')) : ?>
                        <div class="alert alert-danger">
                            <?= session()->getFlashdata('erro') ?>
                        </div>
                    <?php endif; ?>

                     <!-- Primeiro nome -->
                    <div class="mb-3">
                        <?php if (session('errors.text_nome_completo')) : ?>
                            <div class="text-danger small mb-1">
                                <?= session('errors.text_nome_completo') ?>
                            </div>
                        <?php endif; ?>
                        <input type="text" name="text_nome_completo" id="text_nome_completo" class="form-control" placeholder="Nome completo" value="<?= old('text_nome_completo') ?>">
                    </div>    


                    <!-- Empresa -->
                    <div class="mb-3">
                        <?php if (session('errors.text_empresa')) : ?>
                            <div class="text-danger small mb-1">
                                <?= session('errors.text_nome_usuario') ?>
                            </div>
                        <?php endif; ?> 
                        <input type="text" name="text_nome_usuario" id="text_nome_usuario" class="form-control" placeholder="Nome de usuário" value="<?= old('text_nome_usuario') ?>">
                    </div>

                    <!-- E-mail -->
                    <?php if (session('errors.text_email')) : ?>
                        <div class="text-danger small mb-1">
                            <?= session('errors.text_email') ?>
                        </div>
                    <?php endif; ?> 
                    <div class="mb-3">
                        <input type="email" name="text_email" id="text_email" class="form-control" placeholder="E-mail" value="<?= old('text_email') ?>">
                    </div>

                    <!-- Senha de acesso -->
                    <?php if (session('errors.text_senha')) : ?>
                        <div class="text-danger small mb-1">
                            <?= session('errors.text_senha') ?>
                        </div>
                    <?php endif; ?>
                    <div class="mb-3">
                        <input type="password" name="text_senha" id="text_senha" class="form-control" placeholder="Senha de acesso" value="<?= old('text_senha') ?>">
                    </div>
                    
                </div>
                <!-- submit -->
                <div class="row">
                    <div class="mb-3">
                        <button type="submit" class="btn btn-outline-success w-100">
                            <i class="fas fa-check me-2"></i>Criar minha conta
                        </button>
                    </div>
                </div>

                <div class="row">
                     <div class="mb-3">
                     </div>
                </div>

                <?= form_close() ?>
            </div>

      </div>
     
    </div>
  </section>

  <div class="row">
     <div class="mb-3">
     </div>
  </div>

</div>
<script>
    setTimeout(function () {
        const alert = document.getElementById('alert-success');
        if (alert) {
            alert.classList.remove('show');  // Remove "show" para iniciar o fade out
            alert.classList.add('fade');     // Garante que a transição seja aplicada

            // Remove o elemento do DOM após a transição (500ms padrão do Bootstrap)
            setTimeout(() => {
                alert.remove();
            }, 500); 
        }
    }, 5000); // Espera 5 segundos antes de iniciar o fade out
</script>

<?= $this->endSection() ?>

