<?= $this->extend('layouts/layout_main') ?>
<?= $this->section('content') ?>
<?= $this->include('partials/page_title') ?>

<div class="content-box">
    <?= form_open_multipart('/categorias/new_submit') ?>
  
    <div class="row">
    <div class="col-lg-12 col-12 p-5">
            <div class="row">
                <!-- Descricao -->
                <div class="col-sm-6">
                    <div class="mb-3">
                        <label for="nome_categoria" class="form-label2">Nome da categoria</label>
                        <input type="text" name="text_nome_categoria" id="text_nome_categoria" class="form-control" placeholder="Nome da categoria" value="<?= old('text_nome_categoria') ?>">
                        <?= display_error('text_nome_categori', $validation_errors) ?>
                    </div>
                </div>
            </div>
            <div class="row">
                <!-- Descricao -->
                <div class="col-sm-6">
                    <div class="mb-3">
                        <label for="descricao" class="form-label2">Descrição</label>
                        <input type="text" name="text_descricao" id="text_descricao" class="form-control" placeholder="Descrição inicio" value="<?= old('text_descricao') ?>">
                        <?= display_error('text_descricao', $validation_errors) ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Descricao Inicio-->
                <div class="col-sm-6">
                    <div class="mb-3">
                        <label for="descricao" class="form-label2">Descrição apresentada no inicio da categorio</label>
                        <input type="text" name="text_descricao_inicio" id="text_descricao_inicio" class="form-control" placeholder="Descrição inicio" value="<?= old('text_descricao_inicio') ?>">
                        <?= display_error('text_descricao_inicio', $validation_errors) ?>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Descricao_fim -->
                <div class="col-sm-6">
                    <div class="mb-3">
                        <label for="descricao" class="form-label2">Descrição apresentada no fim da categoria</label>
                        <input type="text" name="text_descricao_fim" id="text_descricao_fim" class="form-control" placeholder="Descrição fim" value="<?= old('text_descricao_fim') ?>">
                        <?= display_error('text_descricao_fim', $validation_errors) ?>
                    </div>
                </div>
            </div>
                        
            <div class="row">
                <!-- Situação da categoria-->
                <div class="col-sm-2">
                    <div class="mb-3">
                    <label for="text_active" class="form-label2">Ativo</label>
                        <select  name="text_active" id="text_active" class="form-control">
                              <option>Ativo</option>
                              <option>Inativo</option>
                        </select>
                        <?= display_error('text_active', $validation_errors) ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <hr>
        </div>
        <!-- submit -->
        <div class="row">

            <div class="col px-5 pb-3 text-end">
                <a href="<?= site_url('categorias') ?>" class="btn btn-warning px-4"> <i class="fas fa-ban me-2"></i>Cancelar</a>
                <button type="submit" class="btn btn-primary px-4"><i class="fas fa-check me-2"></i>Salvar </button>
          </div>
        </div>
     
        <?= form_close() ?>
    </div>

    <script src="<?= base_url("assets/libs/datatables/jquery/jquery.min.js"); ?>"></script>
    <script src="<?= base_url("assets/libs/datatables/jquery/jquery.mask.min.js"); ?>"></script>
    <script src="<?= base_url("assets/libs/datatables/jquery/jquery.mask.js"); ?>"></script>
    <script src="<?= base_url("assets/libs/datatables/jquery/scripts.js"); ?>"></script>

    <?php if(!empty($server_error)) : ?>
        <div class="row">
            <div class="col">
                <div class="alert alert-danger p-2">
                    <i class="fa-solid fa-triangle-exclamation me-2"></i><?= $server_error ?>
                </div>
            </div>
        </div>
    <?php endif; ?>

</div>

<?= $this->endSection() ?>

<script>
    // Força ocultar o loader se ele estiver presente, mesmo que essa tela não use #conteudo
    document.addEventListener('DOMContentLoaded', function () {
        const loader = document.getElementById('loader');
        if (loader) loader.style.display = 'none';
    });
</script>

