<?php

namespace App\Models;

use CodeIgniter\Model;

class ConsumptionsModel extends Model
{
    public function get_consumptions($filter_category, $filter_date_interval)
    {
        $db = \Config\Database::connect();

        $params = [
            'id_restaurant' => session()->user['id_restaurant']
        ];

        // filter date interval
        if(!empty($filter_date_interval)){
            $params['start_date'] = $filter_date_interval['start_date']->format('Y-m-d H:i:s');
            $params['end_date'] = $filter_date_interval['end_date']->format('Y-m-d H:i:s');
        }

        // filter category
        if($filter_category != 'all'){
            $params['category'] = $filter_category;
        }

        // get all product from the restaurant
        $sql = "
            SELECT *
            FROM products
            WHERE id_restaurant = :id_restaurant:
        ";

        // filters - category
        if($filter_category != 'all'){
            $sql .= " AND category = :category:";
        }

        $sql .= " ORDER BY id ASC";

        $restaurant_products = $db->query($sql, $params)->getResultArray();

        // get all products from finished orders
        $sql = "
            SELECT
                products.id,
                SUM(order_products.quantity) as quantity
            FROM products LEFT JOIN order_products
            ON products.id = order_products.id_product
            LEFT JOIN orders
            ON orders.id = order_products.id_order
            WHERE orders.id_restaurant = :id_restaurant:
            AND orders.order_status = 'finished'
        ";

        // filters - date interval
        if(!empty($filter_date_interval)){
            $sql .= " AND orders.order_date BETWEEN :start_date: AND :end_date:";
        }

        // filters - category
        if($filter_category != 'all'){
            $sql .= " AND products.category = :category:";
        }

        $sql .= " GROUP BY products.id";

        $orders_results = $db->query($sql, $params)->getResultArray();

        // prepare results
        $results = [];
        foreach($restaurant_products as $product){
            $tmp = $product;
            $tmp['quantity'] = 0;
            foreach($orders_results as $order){
                if($order['id'] == $product['id']){
                    $tmp['quantity'] = $order['quantity'];
                }
            }
            $results[] = $tmp;
        }
        return $results;
    }

    public function get_categories()
    {
        $db = \Config\Database::connect();

        $params = [
            'id_restaurant' => session()->user['id_restaurant']
        ];

        $sql = "
            SELECT DISTINCT category
            FROM products
            WHERE id_restaurant = :id_restaurant:
            AND deleted_at IS NULL
            ORDER BY category ASC
        ";

        return $db->query($sql, $params)->getResultArray();
    }

    public function get_consumptions_by_product($id_product)
    {
        $db = \Config\Database::connect();

        $params = [
            'id_restaurant' => session()->user['id_restaurant'],
            'id_product' => $id_product
        ];

        $sql = "
            SELECT
                DATE_FORMAT(orders.order_date, '%Y-%m-%d') as order_date,
                SUM(order_products.quantity) as quantity
            FROM products LEFT JOIN order_products
            ON products.id = order_products.id_product
            LEFT JOIN orders
            ON orders.id = order_products.id_order
            WHERE orders.id_restaurant = :id_restaurant:
            AND products.id = :id_product:
            GROUP BY DATE_FORMAT(orders.order_date, '%Y-%m-%d')
        ";

        $results = $db->query($sql, $params)->getResultArray();

        return $results;
    }
}
