<?php

namespace App\Database\Seeds;

use App\Models\RestaurantModel;
use App\Models\UserModel;
use CodeIgniter\Database\Seeder;

class RemoveRestaurantSeeder extends Seeder
{
    public function run()
    {
        $this->_output_start_process();

        $json_file = APPPATH . 'Database/Seeds/delete.json';
        
        // check if the delete.json file exists
        $this->_check_json_file($json_file);

        // check json file content
        $this->_check_json_file_content($json_file);

        // get data from json file
        $content = json_decode(file_get_contents($json_file), true);

        // remove restaurant data from database
        $id_restaurant = $content['id_restaurant'];

        $this->_remove_restaurant($id_restaurant);

        echo "Restaurante removido com sucesso." . PHP_EOL;

        $this->_output_end_process();
    }

    private function _remove_restaurant($id_restaurant)
    {
        // delete all data from restaurant
        $db = \Config\Database::connect();

        // delete all order_products associated with the restaurant
        $params = [
            'id_restaurant' => $id_restaurant
        ];
        $db->query("
            DELETE FROM order_products
            WHERE id_order IN
            (
                SELECT id FROM orders WHERE id_restaurant = :id_restaurant:
            )
        ", $params);

        // delete all orders associated with the restaurant
        $db->query("
            DELETE FROM orders WHERE id_restaurant = :id_restaurant:
        ", $params);

        // delete all stocks associated with the restaurant
        $db->query("
            DELETE FROM stocks
            WHERE id_product IN
            (
                SELECT id FROM products WHERE id_restaurant = :id_restaurant:
            )
        ", $params);

        // delete all products associated with the restaurant
        $db->query("
            DELETE FROM products 
            WHERE id_restaurant = :id_restaurant:", $params);

        // delete all users associated with the restaurant
        $db->query("
            DELETE FROM users 
            WHERE id_restaurant = :id_restaurant:", $params);

        // delete restaurant
        $db->query("
            DELETE FROM restaurants 
            WHERE id = :id_restaurant:", $params);
    }

    private function _check_json_file($json_file)
    {
        if(!file_exists($json_file)){
            $this->_output_error("Arquivo delete.json não encontrado.");
            $this->_output_end_process();
            exit;
        }
    }

    private function _check_json_file_content($json_file)
    {
        $json_content = file_get_contents($json_file);
        $json_data = json_decode($json_content, true);

        // check for id_restaurant key
        if(!key_exists('id_restaurant', $json_data)){
            $this->_output_error("Arquivo delete.json não possui a chave 'id_restaurant'");
            $this->_output_end_process();
            exit;
        }
    }

    private function _output_start_process()
    {
        echo PHP_EOL;
        echo str_repeat('-', 50) . PHP_EOL;
        echo "Início do processo de criação de novo restaurante" . PHP_EOL;
        echo str_repeat('-', 50) . PHP_EOL;
    }

    private function _output_error($message)
    {
        echo "Erro: $message" . PHP_EOL;
    }

    private function _output_end_process()
    {
        echo PHP_EOL;
        echo str_repeat('-', 50) . PHP_EOL;
        echo "Fim do processo de criação de novo restaurante" . PHP_EOL;
        echo str_repeat('-', 50) . PHP_EOL;
        echo PHP_EOL;
    }
}
