<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class OrdersSeeder extends Seeder
{
    public function run()
    {
        // config
        $id_start = 0;
        $total_orders = 5000;
        $max_products_per_order = 5;
        $start_date = \DateTime::createFromFormat('Y-m-d H:i:s', '2023-01-01 09:00:00');
        $possible_status = [
            'paid',
            'cancelled',
            'finished'
        ];
        $id = 1;    // the id of the restaurant tha will be used to create orders
        $order_number = 1;
        $trucate_old_data = true;

        // machine_ids
        $machine_ids = [
            ['XFJRVFFU', 'YOEL2X0D', 'R36A6CC1'],
            ['2CIB4D0X', '2TX27LPW', 'WBBFKDQR']
        ];
        $machine_ids = $machine_ids[$id -1];

        // -----------------------------------------
        if($trucate_old_data){
            $this->db->table('orders')->truncate();
            $this->db->table('order_products')->truncate();
        }

        // get all restaurant products
        $products = $this->db->table('products')->where('id_restaurant', $id)->get()->getResult();

        // create orders
        for($i = $id_start; $i < $id_start + $total_orders; $i++){

            // define order products
            $total_products = rand(1, $max_products_per_order);
            $order_products = [];

            // define unique products
            $unique_products = [];
            while(count($unique_products) < $total_products){
                $product = $products[array_rand($products)];
                if(!in_array($product, $unique_products)){
                    $unique_products[] = $product;
                }
            }

            for($j = 0; $j < $total_products; $j++)
            {
                $product = $unique_products[$j];
                $order_products[] = [
                    'id_order' => $i +1,
                    'id_product' => $product->id,
                    'quantity' => rand(1,5),
                    'price_per_unit' => $product->price,
                    'created_at' => $start_date->format('Y-m-d H:i:s'),
                    'updated_at' => null,
                    'deleted_at' => null
                ];
            }
            
            // total price
            $total_price = 0;
            foreach($order_products as $order_product){
                $total_price += $order_product['price_per_unit'] * $order_product['quantity'];
            }

            // define order
            $order = [
                'id' => $i +1,
                'id_restaurant' => $id,
                'machine_id' => $machine_ids[array_rand($machine_ids)],
                'order_date' => $start_date->format('Y-m-d H:i:s'),
                'order_status' => $possible_status[array_rand($possible_status)],
                'total_price' => $total_price,
                'order_number' => $order_number,
                'created_at' => $start_date->format('Y-m-d H:i:s'),
                'updated_at' => null,
                'deleted_at' => null
            ];

            $this->db->table('orders')->insert($order);
            $this->db->table('order_products')->insertBatch($order_products);

            // update start date
            $minuts_to_add = rand(1, 120); // 2 hours max between orders
            $start_date->add(new \DateInterval('PT' . $minuts_to_add . 'M'));

            $order_number++;
        }

        echo PHP_EOL . 'Novas orders criadas com sucesso! Total: ' . $total_orders . PHP_EOL;
    }
}