<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class UsersTable extends Migration
{
    public function up()
    {
        // Create users table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'auto_increment' => TRUE
            ],
            'id_restaurant' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'username' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'passwrd' => [
                'type' => 'VARCHAR',
                'constraint' => 250,
                'null' => TRUE
            ],
            'name' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'email' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'phone' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE
            ],
            'roles' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ],
            'blocked_until' => [
                'type' => 'DATETIME',
                'null' => TRUE
            ],
            'active' => [
                'type' => 'INT',
                'constraint' => 1,
                'null' => TRUE
            ],
            'code' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ],
            'last_login' => [
                'type' => 'DATETIME',
                'null' => TRUE
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => TRUE
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => TRUE
            ],
            'deleted_at' => [
                'type' => 'DATETIME',
                'null' => TRUE
            ]
        ]);

        // primary key
        $this->forge->addKey('id', true);

        // create table
        $this->forge->createTable('users');
    }

    public function down()
    {
        // drop table
        $this->forge->dropTable('users');
    }
}
