<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use App\Models\CategoriaModel;

class Categorias extends BaseController
{
    public function index()
    {

        $id_usuario = session()->user['id'];

         // load all categorias
         $categorias_model = new CategoriaModel();
         $categorias = $categorias_model
         ->where('id_usuario', $id_usuario)
         ->findAll();

         $data = [
             'title' => 'Catetogias',
             'page' => 'Categorias',
             'categorias' => $categorias
         ];
 
         $data['categorias'] = $this->_prepare_categorias_data($categorias);
         $data['datatables'] = true;
 
         return view('dashboard/categorias/index', $data);
    }
    private function _prepare_categorias_data($categorias)
    {
        $data = [];

        foreach ($categorias as $categoria) {
            $data[] = [
                'id' => $categoria->id,
                'descricao' => $categoria->descricao,
                'descricao_inicio' => $categoria->descricao_inicio,
                'descricao_fim' => $categoria->descricao_fim,
                'active' => $categoria->active,
                'created_at' => $categoria->created_at,
                'updated_at' => $categoria->updated_at,
                'deleted_at' => $categoria->deleted_at,
            ];
        }
        return $data;
        
    }

     // ------------------------------------------------
    // new categoria
    // ------------------------------------------------
    public function new_categoria()
    {
        $data = [
            'title' => 'Categoria',
            'page' => 'Nova categoria'
        ];

        // form validation
        $data['validation_errors'] = session()->getFlashdata('validation_errors');

        return view('dashboard/categorias/new_categoria_frm', $data);
    }

    public function new_submit()
    {
         // input fields
         // form validation
        $validation = $this->validate([
            'text_descricao' => [
                'label' => 'descricao',
                'rules' => 'required|min_length[3]|max_length[50]',
                'errors' => [
                    'required' => 'O campo {field} é obrigatório',
                    'min_length' => 'O campo {field} deve ter no mínimo 3 caracteres',
                    'max_length' => 'O campo {field} deve ter no máximo 50 caracteres'
                ]
            ],
            'text_active' => [
                'label' => 'Ativo',
                'rules' => 'required|min_length[3]|max_length[10]',
                'errors' => [
                    'required' => 'O campo {field} é obrigatório',
                    'min_length' => 'O campo {field} deve ter no mínimo 3 caracteres',
                    'max_length' => 'O campo {field} deve ter no máximo 10 caracteres'
                ]
            ]
        ]);

        if (!$validation) {
            return redirect()->back()->withInput()->with('validation_errors', $this->validator->getErrors());
        }
        
        // check se existe uma categoria ja cadastrada
        $categoria_model = new CategoriaModel();
        $categoria = $categoria_model
            ->where('descricao', $this->request->getPost('text_descricao'))
            ->first();
        if ($categoria) {
            return redirect()->back()->withInput()->with('validation_errors', ['text_descricao' => 'Já existe uma categoria com o mesmo nome para esssa Equipe.']);
        }

        
        // prepare dados para insert da categorias
        $ativo = $this->request->getPost('text_active');
        if($ativo==='Ativo'){
          $status=1;   
        } else{
          $status=0;  
        }        

        $id_usuario = session()->user['id'];

        $data = [
            'descricao' => $this->request->getPost('text_descricao'),
            'descricao_inicio' => $this->request->getPost('text_descricao_inicio'),
            'descricao_fim' => $this->request->getPost('text_descricao_fim'),
            'id_usuario' => $id_usuario,
            'active' => $status,
            'created_at' => date('Y-m-d H:i:s')
        ];
        

        // insert data categorias
        $categoria_model->insert($data);

        session()->setFlashdata('success', 'Operação realizada com sucesso!');

        // redirect
        return redirect()->to('/categorias');
    }


     // ------------------------------------------------
    // edit categoria
    // ------------------------------------------------
    public function edit($enc_id)
    {
        $id = Decrypt($enc_id);
        if(empty($id)){
            return redirect()->to('/categorias');
        }

        $data = [
            'title' => 'Categorias',
            'page' => 'Editar categoria'
        ];

        // form validation
        $data['validation_errors'] = session()->getFlashdata('validation_errors');

        // server error
        $data['server_error'] = session()->getFlashdata('server_error');

        // get categoria data
        $categoria_model = new CategoriaModel();
        $data['categoria'] = $categoria_model->find($id);

        return view('dashboard/categorias/edit_categoria_frm', $data);
    }

    public function edit_submit()
    {
        // form validation
        $validation = $this->validate([

            // input fields
            'text_descricao' => [
                'label' => 'Descricao',
                'rules' => 'required|min_length[3]|max_length[50]',
                'errors' => [
                    'required' => 'O campo {field} é obrigatório',
                    'min_length' => 'O campo {field} deve ter no mínimo 3 caracteres',
                    'max_length' => 'O campo {field} deve ter no máximo 50 caracteres'
                ]
            ],
            'text_active' => [
                'label' => 'Ativo',
                'rules' => 'required|min_length[3]|max_length[10]',
                'errors' => [
                    'required' => 'O campo {field} é obrigatório',
                    'min_length' => 'O campo {field} deve ter no mínimo 3 caracteres',
                    'max_length' => 'O campo {field} deve ter no máximo 10 caracteres'
                ]
            ]
            
        ]);


        // check if id is ok
        $id = Decrypt($this->request->getPost('id_categoria'));
        if(empty($id)){
            return redirect()->to('/categorias');
        }
        
        
        if (!$validation) {
            return redirect()->back()->withInput()->with('validation_errors', $this->validator->getErrors());
        }
        
        
        // check if the categorias already exists
        $categoria_model = new CategoriaModel();
        $categoria = $categoria_model
            ->where('descricao', $this->request->getPost('text_descricao'))
            ->where('id !=', $id)
            ->first();

        if($categoria){
            return redirect()->back()->withInput()->with('server_error', 'Já existe uma categoria com o mesmo nome.');
        }
        
        $id_usuario = session()->user['id'];

        // prepare data to update categorias
        
        $data = [
            'descricao' => $this->request->getPost('text_descricao'),
            'descricao_inicio' => $this->request->getPost('text_descricao_inicio'),
            'descricao_fim' => $this->request->getPost('text_descricao_fim'),
            'id_usuario' => $id_usuario,
            'active' => $status,
            'updated_at' => date('Y-m-d H:i:s')
        ];
    
        
        // update categorias
        $categoria_model->update($id, $data);

        session()->setFlashdata('success', 'Operação realizada com sucesso!');

        // redirect
        return redirect()->to('/categorias');
    }


}
