<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use CodeIgniter\Filters\Honeypot;
use CodeIgniter\Filters\InvalidChars;
use CodeIgniter\Filters\SecureHeaders;
use App\Filters\UserIsLoggedIn;
use App\Filters\ApiAuth;
use App\Filters\AdminRoleFilter;

class Filters extends BaseConfig
{
    /**
     * Configures aliases for Filter classes to
     * make reading things nicer and simpler.
     */
    public array $aliases = [
        'csrf'          => CSRF::class,
        'toolbar'       => DebugToolbar::class,
        'honeypot'      => Honeypot::class,
        'invalidchars'  => InvalidChars::class,
        'secureheaders' => SecureHeaders::class,
        'userisloggedin'=> UserIsLoggedIn::class,
        'apiauth'       => ApiAuth::class,
        'adminrole'     => AdminRoleFilter::class
    ];

    /**
     * List of filter aliases that are always
     * applied before and after every request.
     */
    public array $globals = [
        'before' => [
            'userisloggedin' => [
                'except' => [
                    '/',
                    'home',
                    'home/registrarUsuario',
                    '/auth/login',
                    '/auth/login_submit',
                    '/auth/logout',
                    '/auth/finish_registration/*',
                    '/auth/define_password',
                    '/auth/define_password_submit',
                    '/auth/welcome',
                    '/auth/forgot_password',
                    '/auth/forgot_password_submit',
                    '/auth/redefine_password/*',
                    '/auth/redefine_password_submit',
                    '/auth/redefine_password_success',
                    '/api/*'
                ]
            ]
            // 'honeypot',
            // 'csrf',
            // 'invalidchars',
        ],
        'after' => [
            'toolbar',
            // 'honeypot',
            // 'secureheaders',
        ],
    ];

    /**
     * List of filter aliases that works on a
     * particular HTTP method (GET, POST, etc.).
     *
     * Example:
     * 'post' => ['foo', 'bar']
     *
     * If you use this, you should disable auto-routing because auto-routing
     * permits any HTTP method to access a controller. Accessing the controller
     * with a method you don't expect could bypass the filter.
     */
    public array $methods = [];

    /**
     * List of filter aliases that should run on any
     * before or after URI patterns.
     *
     * Example:
     * 'isLoggedIn' => ['before' => ['account/*', 'profiles/*']]
     */
    public array $filters = [
        'apiauth' => [
            'before' => [
                '/api/*'
            ]
        ]
    ];
}
